package ru.yandex.mail.search.web.config.check;

import ru.yandex.mail.search.web.config.check.copyshard.CopyShardConfig;
import ru.yandex.mail.search.web.config.check.copyshard.CopyShardConfigBuilder;
import ru.yandex.mail.search.web.config.check.copyshard.CopyShardConfigDefaults;
import ru.yandex.mail.search.web.config.check.copyshard.ImmutableCopyShardConfig;
import ru.yandex.mail.search.web.config.check.halted.HaltedCheckConfig;
import ru.yandex.mail.search.web.config.check.halted.HaltedCheckConfigBuilder;
import ru.yandex.mail.search.web.config.check.halted.HaltedCheckConfigDefaults;
import ru.yandex.mail.search.web.config.check.halted.ImmutableHaltedCheckConfig;
import ru.yandex.mail.search.web.config.check.peach.ImmutablePeachMetricConfig;
import ru.yandex.mail.search.web.config.check.peach.PeachMetricConfig;
import ru.yandex.mail.search.web.config.check.peach.PeachMetricConfigBuilder;
import ru.yandex.mail.search.web.config.check.peach.PeachMetricConfigDefaults;
import ru.yandex.mail.search.web.health.metrics.CopyShardsMetricFactory;
import ru.yandex.mail.search.web.health.metrics.HaltedShardMetricFactory;
import ru.yandex.mail.search.web.health.metrics.PeachQueueMetricFactory;
import ru.yandex.mail.search.web.health.update.MetricUpdateTaskFactory;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public enum MetricType {
    PEACH {
        @Override
        public MetricUpdateTaskFactory create(
            final IniConfig config)
            throws ConfigException
        {
            PeachMetricConfig metricConfig
                = PeachMetricConfigDefaults.INSTANCE;
            if (config != null) {
                metricConfig = new PeachMetricConfigBuilder(config);
            }

            return new PeachQueueMetricFactory(
                new ImmutablePeachMetricConfig(metricConfig));
        }
    },
    COPYSHARD {
        @Override
        public MetricUpdateTaskFactory create(final IniConfig config)
            throws ConfigException
        {
            CopyShardConfig metricConfig
                = CopyShardConfigDefaults.INSTANCE;
            if (config != null) {
                metricConfig = new CopyShardConfigBuilder(config);
            }

            return new CopyShardsMetricFactory(
                new ImmutableCopyShardConfig(metricConfig));
        }
    },
    HALTED {
        @Override
        public MetricUpdateTaskFactory create(final IniConfig config)
            throws ConfigException
        {
            HaltedCheckConfig metricConfig =
                HaltedCheckConfigDefaults.INSTANCE;
            if (config != null) {
                metricConfig = new HaltedCheckConfigBuilder(config);
            }

            return new HaltedShardMetricFactory(
                new ImmutableHaltedCheckConfig(metricConfig));
        }
    };

    public abstract MetricUpdateTaskFactory create(final IniConfig config)
        throws ConfigException;
}
