package ru.yandex.mail.search.web.config.check.copyshard;

import java.util.LinkedHashSet;
import java.util.Set;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.parser.string.CollectionParser;

public abstract class AbstractCopyShardConfigBuilder
    <T extends AbstractCopyShardConfigBuilder<T>>
     implements CopyShardConfig
{
    private Set<String> services;
    private String name;
    private long timeout;
    private long interval;
    private int dumpPortOffset;

    protected AbstractCopyShardConfigBuilder(final CopyShardConfig config) {
        services(config.services());
        name(config.name());
        timeout(config.timeout());
        interval(config.interval());
        dumpPortOffset(config.dumpPortOffset());
    }

    protected AbstractCopyShardConfigBuilder(
        final IniConfig config,
        final CopyShardConfig defaults)
        throws ConfigException
    {
        this.services =
            config.get(
                "services",
                defaults.services(),
                new CollectionParser<>(
                    String::trim,
                    LinkedHashSet::new));
        this.name = config.getString("name", defaults.name());
        this.timeout = config.getLong("timeout", defaults.timeout());
        this.interval = config.getLong("interval", defaults.interval());
        this.dumpPortOffset =
            config.getInt("dump-port-offset", defaults.dumpPortOffset());
    }

    @Override()
    public Set<String> services() {
        return services;
    }

    public T services(final Set<String> value) {
        this.services = new LinkedHashSet<String>(
            value);
        return self();
    }

    @Override()
    public String name() {
        return name;
    }

    public T name(final String value) {
        this.name = value;
        return self();
    }

    @Override()
    public long timeout() {
        return timeout;
    }

    public T timeout(final long value) {
        this.timeout = value;
        return self();
    }

    @Override()
    public long interval() {
        return interval;
    }

    public T interval(final long value) {
        this.interval = value;
        return self();
    }

    protected abstract T self();

    @Override()
    public int dumpPortOffset() {
        return dumpPortOffset;
    }

    public T dumpPortOffset(final int value) {
        this.dumpPortOffset = value;
        return self();
    }
}
