package ru.yandex.mail.search.web.config.check.copyshard;

import java.util.Collections;
import java.util.Set;

import ru.yandex.parser.config.ConfigException;

public class ImmutableCopyShardConfig
     implements CopyShardConfig
{
    private final Set<String> services;
    private final String name;
    private final long timeout;
    private final long interval;
    private final int dumpPortOffset;

    public ImmutableCopyShardConfig(
        final CopyShardConfig config)
        throws ConfigException
    {
        this.services = Collections.unmodifiableSet(config.services());
        this.name = config.name();
        this.timeout = config.timeout();
        this.interval = config.interval();
        this.dumpPortOffset = config.dumpPortOffset();
    }

    @Override
    public Set<String> services() {
        return services;
    }

    @Override
    public String name() {
        return name;
    }

    @Override
    public long timeout() {
        return timeout;
    }

    @Override
    public long interval() {
        return interval;
    }

    @Override
    public int dumpPortOffset() {
        return dumpPortOffset;
    }
}
