package ru.yandex.mail.search.web.config.check.halted;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractHaltedCheckConfigBuilder
    <T extends AbstractHaltedCheckConfigBuilder<T>>
     implements HaltedCheckConfig
{
    private long timeout;
    private long interval;
    private int consumerPortOffset;

    protected AbstractHaltedCheckConfigBuilder(final HaltedCheckConfig config) {
        timeout(config.timeout());
        interval(config.interval());
        consumerPortOffset(config.consumerPortOffset());
    }

    protected AbstractHaltedCheckConfigBuilder(
        final IniConfig config,
        final HaltedCheckConfig defaults)
        throws ConfigException
    {
        this.timeout = config.getLong("timeout", defaults.timeout());
        this.interval = config.getLong("interval", defaults.interval());
        this.consumerPortOffset =
            config.getInt(
                "consumer-port-offset",
                defaults.consumerPortOffset());
    }

    @Override()
    public long timeout() {
        return timeout;
    }

    public T timeout(final long value) {
        this.timeout = value;
        return self();
    }

    @Override()
    public long interval() {
        return interval;
    }

    public T interval(final long value) {
        this.interval = value;
        return self();
    }

    @Override()
    public int consumerPortOffset() {
        return consumerPortOffset;
    }

    public T consumerPortOffset(final int value) {
        this.consumerPortOffset = value;
        return self();
    }

    protected abstract T self();
}
