package ru.yandex.mail.search.web.config.check.halted;

import ru.yandex.parser.config.ConfigException;

public class ImmutableHaltedCheckConfig implements HaltedCheckConfig {
    private final long timeout;
    private final long interval;
    private final int consumerPortOffset;

    public ImmutableHaltedCheckConfig(
        final HaltedCheckConfig config)
        throws ConfigException
    {
        this.timeout = config.timeout();
        this.interval = config.interval();
        this.consumerPortOffset = config.consumerPortOffset();
    }

    @Override
    public long timeout() {
        return timeout;
    }

    @Override
    public long interval() {
        return interval;
    }

    @Override
    public int consumerPortOffset() {
        return consumerPortOffset;
    }
}
