package ru.yandex.mail.search.web.config.check.peach;

import java.net.URI;
import java.util.LinkedHashSet;
import java.util.Set;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.parser.string.CollectionParser;

public abstract class AbstractPeachMetricConfigBuilder
    <T extends AbstractPeachMetricConfigBuilder<T>>
     implements PeachMetricConfig
{
    private String noQueueFilterQuery;
    private String queueFilterQuery;
    private URI queuelenBaseUri;
    private URI validateBaseUri;
    private long timeout;
    private long interval;
    private long threshold;
    private String name;
    private String sortField;
    private Set<String> queues;
    private Set<String> fields;
    private Set<String> services;

    protected AbstractPeachMetricConfigBuilder(final PeachMetricConfig config) {
        noQueueFilterQuery(config.noQueueFilterQuery());
        queueFilterQuery(config.queueFilterQuery());
        timeout(config.timeout());
        interval(config.interval());
        threshold(config.threshold());
        name(config.name());
        fields(config.fields());
        sortField(config.sortField());
        services(config.services());
        queuelenBaseUri(config.queuelenBaseUri());
        validateBaseUri(config.validateBaseUri());
        queues(config.queues());
    }

    protected AbstractPeachMetricConfigBuilder(
        final IniConfig config,
        final PeachMetricConfig defaults)
        throws ConfigException
    {
        this.noQueueFilterQuery =
                config.getString("no-queue-filter-query", defaults.noQueueFilterQuery());
        this.queueFilterQuery =
            config.getString("queue-filter-query", defaults.queueFilterQuery());
        this.queuelenBaseUri = config.getURI("queuelen-uri", defaults.queuelenBaseUri());
        this.validateBaseUri = config.getURI("validate-uri", defaults.validateBaseUri());
        this.timeout = config.getLong("timeout", defaults.timeout());
        this.interval = config.getLong("interval", defaults.interval());
        this.threshold = config.getLong("threshold", defaults.threshold());
        this.name = config.getString("name", defaults.name());
        this.sortField = config.getString("sort-field", defaults.sortField());
        this.queues =
            config.get(
                "queues",
                defaults.queues(),
                new CollectionParser<>(
                    String::trim,
                    LinkedHashSet::new));

        this.fields = config.get(
                "fields",
                defaults.fields(),
                new CollectionParser<>(
                        String::trim,
                        LinkedHashSet::new));
        this.services =
            config.get(
                "services",
                defaults.services(),
                new CollectionParser<>(
                    String::trim,
                    LinkedHashSet::new));
    }

    @Override()
    public String noQueueFilterQuery() {
        return noQueueFilterQuery;
    }

    public T noQueueFilterQuery(final String value) {
        this.noQueueFilterQuery = value;
        return self();
    }

    @Override()
    public String queueFilterQuery() {
        return queueFilterQuery;
    }

    public T queueFilterQuery(final String value) {
        this.queueFilterQuery = value;
        return self();
    }

    @Override
    public URI queuelenBaseUri() {
        return queuelenBaseUri;
    }

    public T queuelenBaseUri(final URI queuelenBaseUri) {
        this.queuelenBaseUri = queuelenBaseUri;
        return self();
    }

    @Override
    public URI validateBaseUri() {
        return validateBaseUri;
    }

    public T validateBaseUri(final URI validateBaseUri) {
        this.validateBaseUri = validateBaseUri;
        return self();
    }

    @Override()
    public long timeout() {
        return timeout;
    }

    public T timeout(final long value) {
        this.timeout = value;
        return self();
    }

    @Override()
    public long interval() {
        return interval;
    }

    public T interval(final long value) {
        this.interval = value;
        return self();
    }

    @Override()
    public long threshold() {
        return threshold;
    }

    public T threshold(final long value) {
        this.threshold = value;
        return self();
    }

    @Override()
    public String name() {
        return name;
    }

    public T name(final String value) {
        this.name = value;
        return self();
    }

    @Override()
    public String sortField() {
        return sortField;
    }

    public T sortField(final String value) {
        this.sortField = value;
        return self();
    }

    @Override()
    public Set<String> queues() {
        return queues;
    }

    public T queues(final Set<String> value) {
        this.queues = new LinkedHashSet<>(value);
        return self();
    }

    protected abstract T self();

    @Override()
    public Set<String> fields() {
        return fields;
    }

    public T fields(final Set<String> value) {
        this.fields = new LinkedHashSet<String>(
                value);
        return self();
    }

    @Override()
    public Set<String> services() {
        return services;
    }

    public T services(final Set<String> value) {
        this.services = new LinkedHashSet<String>(
            value);
        return self();
    }
}
