package ru.yandex.mail.search.web.config.check.peach;

import java.net.URI;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

import ru.yandex.parser.config.ConfigException;

public class ImmutablePeachMetricConfig
     implements PeachMetricConfig
{
    private final String noQueueFilterQuery;
    private final String queueFilterQuery;
    private final URI queuelenBaseUri;
    private final URI validateBaseUri;
    private final long timeout;
    private final long interval;
    private final long threshold;
    private final String name;
    private final String sortField;
    private final Set<String> queues;
    private final Set<String> services;
    private final Set<String> fields;

    public ImmutablePeachMetricConfig(
        final PeachMetricConfig config)
        throws ConfigException
    {
        this.noQueueFilterQuery = config.noQueueFilterQuery();
        this.queueFilterQuery = config.queueFilterQuery();
        this.queuelenBaseUri = config.queuelenBaseUri();
        this.validateBaseUri = config.validateBaseUri();

        this.timeout = config.timeout();
        this.interval = config.interval();
        this.threshold = config.threshold();
        this.name = config.name();
        this.sortField = config.sortField();
        this.queues = Collections.unmodifiableSet(new LinkedHashSet<>(config.queues()));
        if (queues.isEmpty()) {
            throw new ConfigException(
                "Param: queues for peach config was not set for name: "
                    + this.name);
        }
        this.services = Collections.unmodifiableSet(new LinkedHashSet<>(config.services()));
        this.fields = Collections.unmodifiableSet(new LinkedHashSet<>(config.fields()));
    }

    @Override
    public String noQueueFilterQuery() {
        return noQueueFilterQuery;
    }

    @Override
    public String queueFilterQuery() {
        return queueFilterQuery;
    }

    @Override
    public long timeout() {
        return timeout;
    }

    @Override
    public long interval() {
        return interval;
    }

    @Override
    public long threshold() {
        return threshold;
    }

    @Override
    public String name() {
        return name;
    }

    @Override
    public String sortField() {
        return sortField;
    }

    @Override
    public Set<String> services() {
        return services;
    }

    @Override
    public Set<String> fields() {
        return fields;
    }

    @Override
    public URI queuelenBaseUri() {
        return queuelenBaseUri;
    }

    @Override
    public URI validateBaseUri() {
        return validateBaseUri;
    }

    @Override
    public Set<String> queues() {
        return queues;
    }
}
