package ru.yandex.mail.search.web.config.check.peach;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class PeachMetricConfigDefaults
     implements PeachMetricConfig
{
    public static final String DEFAULT_PEACH_QUEUE = "null";

    private static final String DEFAULT_QUEUELEN_URI_STR =
        "/printkeys-peach?IO_PRIO=10000&hr&print-freqs&skip-deleted&max-freq=0"
            + "&prefixless-field=peach_url&prefixless-field=peach_queue&webtools&field=peach_url&text=";

    private static final URI DEFAULT_QUEUELEN_URI;
    private static final String DEFAULT_VALIDATE_URI_STR =
        "/search-peach?json-type=dollar&IO_PRIO=3000&memory-limit=33554432&asc&webtools";
    private static final URI DEFAULT_VALIDATE_URI;

    static {
        try {
            DEFAULT_QUEUELEN_URI = new URI(DEFAULT_QUEUELEN_URI_STR);
            DEFAULT_VALIDATE_URI = new URI(DEFAULT_VALIDATE_URI_STR);
        } catch (URISyntaxException urie) {
            throw new RuntimeException(urie);
        }
    }

    private static final String DEFAULT_QUEUE_VALIDATE_QUERY =
        "&text=peach_url:1+AND+NOT+peach_queue:*";
    private static final String QUEUE_FILTER_TEXT =
            "&text=peach_url:1+AND+peach_queue:";
    private static final long DEFAULT_TIMEUT = 30000;
    private static final long DEFAULT_INTERVAL =
        TimeUnit.MINUTES.toMillis(3);
    private static final long DEFAULT_THRESHOLD = 10000;
    public static final PeachMetricConfigDefaults INSTANCE =
        new PeachMetricConfigDefaults();

    private PeachMetricConfigDefaults() {
    }

    @Override
    public String noQueueFilterQuery() {
        return DEFAULT_QUEUE_VALIDATE_QUERY;
    }

    @Override
    public String queueFilterQuery() {
        return QUEUE_FILTER_TEXT;
    }

    @Override
    public long timeout() {
        return DEFAULT_TIMEUT;
    }

    @Override
    public long interval() {
        return DEFAULT_INTERVAL;
    }

    @Override
    public long threshold() {
        return DEFAULT_THRESHOLD;
    }

    @Override
    public String name() {
        return "default";
    }

    @Override
    public Set<String> services() {
        return Collections.emptySet();
    }

    @Override
    public Set<String> fields() {
        return Collections.emptySet();
    }

    @Override
    public String sortField() {
        return null;
    }

    @Override
    public Set<String> queues() {
        return Collections.singleton(DEFAULT_PEACH_QUEUE);
    }

    @Override
    public URI queuelenBaseUri() {
        return DEFAULT_QUEUELEN_URI;
    }

    @Override
    public URI validateBaseUri() {
        return DEFAULT_VALIDATE_URI;
    }
}
