package ru.yandex.mail.search.web.config.mail;

import ru.yandex.client.tvm2.Tvm2ClientConfig;
import ru.yandex.client.tvm2.Tvm2ClientConfigBuilder;
import ru.yandex.http.config.FilterSearchConfig;
import ru.yandex.http.config.FilterSearchConfigBuilder;
import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpHostConfigBuilder;
import ru.yandex.http.config.HttpTargetConfig;
import ru.yandex.http.config.HttpTargetConfigBuilder;
import ru.yandex.mail.search.web.config.AbstractPsProjectConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractMailSearchConfigBuilder
    <T extends AbstractMailSearchConfigBuilder<T>>
     extends AbstractPsProjectConfigBuilder<T>
     implements MailSearchConfig
{
    private String mainQueue;
    private String reindexQueue;
    private HttpHostConfigBuilder reindexProducer;
    private FilterSearchConfigBuilder filterSearch;
    private HttpHostConfigBuilder mailSearch;
    private HttpHostConfigBuilder msal;
    private HttpHostConfigBuilder iex;
    private HttpTargetConfigBuilder searchConfig;
    private String yasmProject;
    private Tvm2ClientConfigBuilder filterSearchTvm2;

    protected AbstractMailSearchConfigBuilder(final MailSearchConfig config) {
        super(config);
        this.filterSearch(config.filterSearch());
        this.reindexQueue(config.reindexQueue());
        this.mainQueue(config.mainQueue());
        this.reindexProducer(config.reindexProducer());
        this.mailSearch(config.mailSearch());
        this.msal(config.msal());
        this.iex(config.iex());
        this.searchConfig(config.searchConfig());
        this.yasmProject(config.yasmProject());
        this.filterSearchTvm2(config.filterSearchTvm2());
    }

    protected AbstractMailSearchConfigBuilder(
        final IniConfig config,
        final MailSearchConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
        this.mailSearch =
            new HttpHostConfigBuilder(
                config.section("msearch-proxy"),
                defaults.mailSearch());
        this.msal =
            new HttpHostConfigBuilder(
                config.section("msal"),
                defaults.mailSearch());
        this.iex =
            new HttpHostConfigBuilder(
                config.section("iex"),
                defaults.mailSearch());
        this.reindexProducer =
            new HttpHostConfigBuilder(
                config.section("reindex-producer"),
                defaults.mailSearch());
        this.mainQueue =
            config.getString("main_queue", defaults.mainQueue());
        this.reindexQueue =
            config.getString("reindex_queue", defaults.reindexQueue());
        IniConfig filterSearchSection = config.section("filter-search");
        this.filterSearch =
            new FilterSearchConfigBuilder(
                filterSearchSection,
                defaults.filterSearch());
        this.filterSearchTvm2 = new Tvm2ClientConfigBuilder(
            filterSearchSection.section("tvm2"),
            defaults.filterSearchTvm2());

        this.searchConfig =
            new HttpTargetConfigBuilder(
                config.section("search"),
                defaults.searchConfig());
        this.yasmProject =
            config.getString("yasm-project", defaults.yasmProject());
    }

    @Override()
    public String mainQueue() {
        return mainQueue;
    }

    public T mainQueue(final String value) {
        this.mainQueue = value;
        return self();
    }

    @Override()
    public String reindexQueue() {
        return reindexQueue;
    }

    public T reindexQueue(final String value) {
        this.reindexQueue = value;
        return self();
    }

    @Override()
    public HttpHostConfigBuilder reindexProducer() {
        return reindexProducer;
    }

    public T reindexProducer(final HttpHostConfig value) {
        this.reindexProducer = new HttpHostConfigBuilder(
            value);
        return self();
    }

    @Override()
    public FilterSearchConfigBuilder filterSearch() {
        return filterSearch;
    }

    public T filterSearch(final FilterSearchConfig value) {
        this.filterSearch = new FilterSearchConfigBuilder(
            value);
        return self();
    }

    @Override()
    public HttpHostConfigBuilder mailSearch() {
        return mailSearch;
    }

    public T mailSearch(final HttpHostConfig value) {
        this.mailSearch = new HttpHostConfigBuilder(
            value);
        return self();
    }

    @Override()
    public HttpHostConfigBuilder msal() {
        return msal;
    }

    public T msal(final HttpHostConfig value) {
        this.msal = new HttpHostConfigBuilder(
            value);
        return self();
    }

    @Override()
    public HttpHostConfigBuilder iex() {
        return iex;
    }

    public T iex(final HttpHostConfig value) {
        this.iex = new HttpHostConfigBuilder(
            value);
        return self();
    }

    @Override()
    public HttpTargetConfigBuilder searchConfig() {
        return searchConfig;
    }

    public T searchConfig(final HttpTargetConfig value) {
        this.searchConfig = new HttpTargetConfigBuilder(
            value);
        return self();
    }

    @Override()
    public String yasmProject() {
        return yasmProject;
    }

    public T yasmProject(final String value) {
        this.yasmProject = value;
        return self();
    }

    @Override
    public Tvm2ClientConfigBuilder filterSearchTvm2() {
        return filterSearchTvm2;
    }

    public T filterSearchTvm2(
        final Tvm2ClientConfig filterSearchTvm2)
    {
        this.filterSearchTvm2 = new Tvm2ClientConfigBuilder(filterSearchTvm2);
        return self();
    }
}
