package ru.yandex.mail.search.web.config.mail;

import ru.yandex.client.tvm2.ImmutableTvm2ClientConfig;
import ru.yandex.http.config.ImmutableFilterSearchConfig;
import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.http.config.ImmutableHttpTargetConfig;
import ru.yandex.mail.search.web.config.ImmutablePsProjectConfig;
import ru.yandex.parser.config.ConfigException;

public class ImmutableMailSearchConfig
     extends ImmutablePsProjectConfig
     implements MailSearchConfig
{
    private final String mainQueue;
    private final String reindexQueue;
    private final ImmutableHttpHostConfig reindexProducer;
    private final ImmutableFilterSearchConfig filterSearch;
    private final ImmutableHttpHostConfig mailSearch;
    private final ImmutableHttpHostConfig msal;
    private final ImmutableHttpHostConfig iex;
    private final ImmutableHttpTargetConfig searchConfig;
    private final String yasmProject;
    private final ImmutableTvm2ClientConfig filterSearchTvm2;

    public ImmutableMailSearchConfig(
        final MailSearchConfig config)
        throws ConfigException
    {
        super(config);
        this.mainQueue = config.mainQueue();
        this.reindexQueue = config.reindexQueue();
        this.reindexProducer =
            new ImmutableHttpHostConfig(
                config.reindexProducer());
        this.filterSearch =
            new ImmutableFilterSearchConfig(
                config.filterSearch());
        this.mailSearch = new ImmutableHttpHostConfig(
            config.mailSearch());
        this.msal = new ImmutableHttpHostConfig(
            config.msal());
        this.iex = new ImmutableHttpHostConfig(
            config.iex());
        this.searchConfig =
            new ImmutableHttpTargetConfig(
                config.searchConfig());
        this.yasmProject = config.yasmProject();

        this.filterSearchTvm2 = new ImmutableTvm2ClientConfig(config.filterSearchTvm2());
    }

    @Override
    public String mainQueue() {
        return mainQueue;
    }

    @Override
    public String reindexQueue() {
        return reindexQueue;
    }

    @Override
    public ImmutableHttpHostConfig reindexProducer() {
        return reindexProducer;
    }

    @Override
    public ImmutableFilterSearchConfig filterSearch() {
        return filterSearch;
    }

    @Override
    public ImmutableHttpHostConfig mailSearch() {
        return mailSearch;
    }

    @Override
    public ImmutableHttpHostConfig msal() {
        return msal;
    }

    @Override
    public ImmutableHttpHostConfig iex() {
        return iex;
    }

    @Override
    public ImmutableHttpTargetConfig searchConfig() {
        return searchConfig;
    }

    @Override
    public String yasmProject() {
        return yasmProject;
    }

    @Override
    public String defaultService() {
        return mainQueue();
    }

    @Override
    public ImmutableTvm2ClientConfig filterSearchTvm2() {
        return filterSearchTvm2;
    }
}
