package ru.yandex.mail.search.web.config.mail;

import ru.yandex.mail.search.web.config.PsProjectConfig;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class MailSearchConfigBuilder
     extends AbstractMailSearchConfigBuilder<MailSearchConfigBuilder>
{
    public MailSearchConfigBuilder(final PsProjectConfig config) {
        this((MailSearchConfig) config);
    }

    public MailSearchConfigBuilder() {
        this(MailSearchConfigDefaults.INSTANCE);
    }

    public MailSearchConfigBuilder(final MailSearchConfig config) {
        super(config);
    }

    public MailSearchConfigBuilder(
        final IniConfig config)
        throws ConfigException
    {
        this(config, MailSearchConfigDefaults.INSTANCE);
    }

    public MailSearchConfigBuilder(
        final IniConfig config,
        final MailSearchConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    public ImmutableMailSearchConfig build() throws ConfigException {
        return new ImmutableMailSearchConfig(
            this);
    }

    @Override
    public MailSearchConfigBuilder self() {
        return this;
    }
}
