package ru.yandex.mail.search.web.disk.serp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;

import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.protocol.BasicAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.protocol.HttpContext;

import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.proxy.BasicProxySession;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.nio.BasicAsyncResponseConsumerFactory;
import ru.yandex.http.util.nio.BasicAsyncResponseProducerGenerator;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.http.util.nio.client.AsyncGetURIRequestProducerSupplier;
import ru.yandex.mail.search.web.WebApi;
import ru.yandex.parser.uri.QueryConstructor;

public class DiskImageHandler implements HttpAsyncRequestHandler<HttpRequest> {
    private static final int DEFAULT_MAX_WIDTH = 300;
    private static final int DEFAULT_MAX_HEIGHT = 300;
    private static final String DEFAULT_FORMAT = "png";

    private final WebApi proxy;

    public DiskImageHandler(final WebApi proxy) {
        this.proxy = proxy;
    }

    @Override
    public HttpAsyncRequestConsumer<HttpRequest> processRequest(
        final HttpRequest request,
        final HttpContext context)
        throws HttpException, IOException
    {
        return new BasicAsyncRequestConsumer();
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpAsyncExchange exchange,
        final HttpContext context)
        throws HttpException, IOException
    {
        BasicProxySession session =
            new BasicProxySession(proxy, exchange, context);
        QueryConstructor qc =
            new QueryConstructor(
                proxy.config().mds().uri()
                    + session.params().getString("stid"));
        AsyncClient client = proxy.mdsClient().adjust(session.context());

        MdsProxyCallback callback = new MdsProxyCallback(session);
        try {
            client.execute(
                new AsyncGetURIRequestProducerSupplier(qc.toString()),
                BasicAsyncResponseConsumerFactory.OK,
                session.listener().adjustContextGenerator(
                    client.httpClientContextGenerator()),
                callback);
        } catch (URISyntaxException ue) {
            callback.failed(ue);
        }
    }

    private static final class MdsProxyCallback
        extends AbstractProxySessionCallback<HttpResponse>
    {
        private final int width;
        private final int height;
        private final String format;

        private MdsProxyCallback(
            final ProxySession session)
            throws BadRequestException
        {
            super(session);

            this.width =
                session.params().getInt("width", DEFAULT_MAX_WIDTH);
            this.height =
                session.params().getInt("height", DEFAULT_MAX_HEIGHT);
            this.format =
                session.params().getString("format", DEFAULT_FORMAT);
        }

        @Override
        public void completed(final HttpResponse response) {
            try {
                int statusCode = response.getStatusLine().getStatusCode();
                HttpEntity entity = response.getEntity();
                if (statusCode == HttpStatus.SC_OK) {
                    ByteArrayOutputStream os =
                        new ByteArrayOutputStream();
                    IOUtils.copy(response.getEntity().getContent(), os);
//                    Thumbnails.of()
//                        .size(width, height)
//                        .outputFormat(format)
//                        .toOutputStream(os);
                    entity = new ByteArrayEntity(
                        os.toByteArray(),
                        ContentType.IMAGE_PNG);
                }

                BasicAsyncResponseProducerGenerator generator =
                    new BasicAsyncResponseProducerGenerator(
                        statusCode,
                        entity);
                session.response(generator.get());
            } catch (IOException ioe) {
                failed(ioe);
            }
        }
    }
}
