package ru.yandex.mail.search.web.drop;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import ru.yandex.mail.search.web.health.Metrica;
import ru.yandex.mail.search.web.health.base.PropertyStatus;
import ru.yandex.mail.search.web.health.base.Shard;
import ru.yandex.mail.search.web.health.base.ShardReplica;

public abstract class AbstractDropHandler {
    protected ShardDroppableCheckResult calcShard(
        final Shard shard,
        final ShardReplica exclude)
    {
        Map<String, List<PropertyStatus>> statuses = new LinkedHashMap<>();

        for (ShardReplica replica: shard.replicasCollection()) {
            if (replica == exclude) {
                continue;
            }

            for (Metrica property: replica.metrics()) {
                statuses.computeIfAbsent(
                    property.type(),
                    (k) -> new ArrayList<>()).add(property.status());
            }
        }

        int worstScore = 0;
        int worstLeftAlive = Integer.MAX_VALUE;
        String worstMetric = null;

        Map<String, String> metricsResult = new LinkedHashMap<>();
        for (Map.Entry<String, List<PropertyStatus>> entry
            : statuses.entrySet())
        {
            int score = 0;
            for (PropertyStatus status: entry.getValue()) {
                if (status != PropertyStatus.OK) {
                    score += 1;
                }
            }

            int leftAlive = entry.getValue().size() - score;
            if (leftAlive < worstLeftAlive) {
                worstScore = score;
                worstMetric = entry.getKey();
                worstLeftAlive = leftAlive;
            }

            metricsResult.put(
                entry.getKey(),
                String.valueOf(score) + '/' + entry.getValue().size());
        }

        return new ShardDroppableCheckResult(shard, worstScore, worstLeftAlive, worstMetric, metricsResult);
    }
}
