package ru.yandex.mail.search.web.drop;

import java.util.List;
import java.util.Set;

import org.apache.http.HttpHost;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.logger.PrefixedLogger;
import ru.yandex.mail.search.web.DefaultPsProject;

public class DropContext {
    private final String hostname;
    private final int basePort;
    private final List<ShardDroppableCheckResult> shards;

    private final DefaultPsProject project;
    private final ProxySession session;
    private final Set<String> queues;
    private final HttpHost indexerHost;
    private final HttpHost consumerHost;
    private final AsyncClient client;

    public DropContext(
        final String hostname,
        final int basePort,
        final List<ShardDroppableCheckResult> shards,
        final DefaultPsProject project,
        final ProxySession session,
        final Set<String> queues)
    {
        this.hostname = hostname;
        this.basePort = basePort;
        this.shards = shards;
        this.project = project;
        this.session = session;
        this.queues = queues;
        this.indexerHost = new HttpHost(hostname, basePort + 2);
        this.consumerHost = new HttpHost(hostname, basePort + 3);
        this.client =
            project.dropShardClient().adjust(session.context());
    }

    public String hostname() {
        return hostname;
    }

    public int basePort() {
        return basePort;
    }

    public List<ShardDroppableCheckResult> shards() {
        return shards;
    }

    public DefaultPsProject project() {
        return project;
    }

    public ProxySession session() {
        return session;
    }

    public Set<String> queues() {
        return queues;
    }

    public HttpHost indexerHost() {
        return indexerHost;
    }

    public HttpHost consumerHost() {
        return consumerHost;
    }

    public AsyncClient client() {
        return client;
    }

    public PrefixedLogger logger() {
        return session.logger();
    }
}
