package ru.yandex.mail.search.web.drop;

import java.io.IOException;
import java.util.Map;

import ru.yandex.io.StringBuilderWriter;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonValue;
import ru.yandex.json.writer.JsonWriter;
import ru.yandex.json.writer.JsonWriterBase;
import ru.yandex.mail.search.web.health.base.PropertyStatus;
import ru.yandex.mail.search.web.health.base.Shard;

public class ShardDroppableCheckResult implements JsonValue {
    private final Shard shard;
    private final int worstScore;
    private final int worstLeftAlive;
    private final String metric;

    private final Map<String, String> metricResult;
    private final PropertyStatus status;

    public ShardDroppableCheckResult(
        final Shard shard,
        final int worstScore,
        final int worstLeftAlive,
        final String metric,
        final Map<String, String> metricResult)
    {
        this.shard = shard;
        this.worstScore = worstScore;
        this.worstLeftAlive = worstLeftAlive;
        this.metric = metric;
        this.metricResult = metricResult;

        if (worstLeftAlive <= 0) {
            status = PropertyStatus.ERROR;
        } else if (worstLeftAlive <= 1) {
            status = PropertyStatus.WARNING;
        } else{
            status = PropertyStatus.OK;
        }
    }

    public Shard shard() {
        return shard;
    }

    public int worstScore() {
        return worstScore;
    }

    public int worstLeftAlive() {
        return worstLeftAlive;
    }

    public String metric() {
        return metric;
    }

    public PropertyStatus status() {
        return status;
    }

    @Override
    public String toString() {
        StringBuilderWriter sbw = new StringBuilderWriter();
        try (JsonWriter jw = JsonType.NORMAL.create(sbw)) {
            writeValue(jw);
        } catch (IOException ioe) {
            ioe.printStackTrace();
            return ioe.getMessage();
        }

        return sbw.toString();
    }

    @Override
    public void writeValue(final JsonWriterBase writer) throws IOException {
        writer.startObject();
        writer.key("queue");
        writer.value(shard.queueName());
        writer.key("shardId");
        writer.value(shard.id());
        writer.key("status");
        writer.value(status);
        writer.key("metric");
        writer.value(metric);
        writer.key("errors");
        writer.value(worstScore);
        writer.key("alive");
        writer.value(worstLeftAlive);
        writer.key("metrics");
        writer.startArray();
        for (Map.Entry<String, String> entry: metricResult.entrySet()) {
            writer.startObject();
            writer.key("name");
            writer.value(entry.getKey());
            writer.key("value");
            writer.value(entry.getValue());
            writer.endObject();
        }
        writer.endArray();
        writer.endObject();
    }
}
