package ru.yandex.mail.search.web.health;

import ru.yandex.mail.search.web.health.base.PropertyStatus;
import ru.yandex.mail.search.web.health.base.ShardMetric;

public abstract class AbstractShardMetric<T> implements ShardMetric {
    protected static final String OK_STATUS_DESCRIPTION = "ok";
    protected static final String NO_DATA = "no data";
    protected long updateTs = -1L;
    protected PropertyStatus status = PropertyStatus.ERROR;
    protected String statusDescription = NO_DATA;

    protected final String name;

    public AbstractShardMetric(final String name) {
        this.name = name;
    }

    protected abstract void internalUpdate(final T value);

    public synchronized void update(final T value, final String message) {
        updateTs = System.currentTimeMillis();
        statusDescription = message;
        internalUpdate(value);
    }

    public synchronized void update(final T value) {
        update(value, OK_STATUS_DESCRIPTION);
    }

    public synchronized void updateError(final String message) {
        updateTs = System.currentTimeMillis();
        status = PropertyStatus.ERROR;
        statusDescription = message;
    }

    @Override
    public long lastUpdateTs() {
        return updateTs;
    }

    @Override
    public synchronized PropertyStatus propertyStatus() {
        return status;
    }

    @Override
    public synchronized String statusDescription() {
        return statusDescription;
    }

    @Override
    public String name() {
        return name;
    }
}
