package ru.yandex.mail.search.web.health;

import java.util.concurrent.TimeUnit;

import ru.yandex.mail.search.web.health.base.PropertyStatus;

public class BasicMetrica implements Metrica {
    protected static final String NO_DATA_DESC
        = " но последняя проверка была ";
    protected static final long DEFAULT_NO_DATA_THRESHOLD_MS =
        TimeUnit.MINUTES.toMillis(10L);

    protected final String name;
    protected final String type;
    protected final long noDataTimeout;

    protected long updateTs = -1L;
    protected PropertyStatus status = PropertyStatus.ERROR;
    protected String description;

    public BasicMetrica(final String name, final String type) {
        this(name, type, type + "- no data", DEFAULT_NO_DATA_THRESHOLD_MS);
    }

    public BasicMetrica(
        final String name,
        final String type,
        final String defaultDescription)
    {
        this(name, type, defaultDescription,  DEFAULT_NO_DATA_THRESHOLD_MS);
    }

    public BasicMetrica(
        final String name,
        final String type,
        final String defaultDescription,
        final long noDataTimeout)
    {
        this.name = name;
        this.noDataTimeout = noDataTimeout;
        this.type = type;
        this.description = defaultDescription;
    }

    @Override
    public synchronized void recalculateStatus() {
        long diff = System.currentTimeMillis() - updateTs;
        if (status != PropertyStatus.ERROR && diff > noDataTimeout) {
            status = PropertyStatus.ERROR;
            description =
                description + NO_DATA_DESC
                    + Metrica.timeToHuman(diff) + " назад";
        }
    }

    public synchronized PropertyStatus status() {
        return status;
    }

    public synchronized void ok(final String description) {
        this.updateTs = System.currentTimeMillis();
        this.status = PropertyStatus.OK;
        this.description = description;
    }

    public synchronized void error(final String description) {
        this.updateTs = System.currentTimeMillis();
        this.status = PropertyStatus.ERROR;
        this.description = description;
    }

    public synchronized long updateTs() {
        return updateTs;
    }

    public synchronized String description() {
        return description;
    }

    public String name() {
        return name;
    }

    public String type() {
        return type;
    }
}
