package ru.yandex.mail.search.web.health;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class DcAwareHostname {
    private static final Set<String> DCS =
        Collections.unmodifiableSet(
            new LinkedHashSet<>(
                Arrays.asList("sas", "vla", "man", "iva", "myt")));
    private static final String UNKNOWN_DC = "unknown_dc";

    private final String hostname;
    private final String dc;

    public DcAwareHostname(String hostname) {
        this.hostname = hostname;
        this.dc = extractDc(hostname);
    }

    public String hostname() {
        return hostname;
    }

    public String dc() {
        return dc;
    }

    public static final int dcCount() {
        return DCS.size() + 1;
    }

    public static final String extractDc(final String hostname) {
        String hostDc = UNKNOWN_DC;
        for (String dc: DCS) {
            if (hostname.startsWith(dc)) {
                hostDc = dc;
                break;
            }
        }

        return hostDc;
    }
}
