package ru.yandex.mail.search.web.health;

import java.io.IOException;
import java.util.concurrent.TimeUnit;

import ru.yandex.json.writer.JsonValue;
import ru.yandex.json.writer.JsonWriterBase;
import ru.yandex.mail.search.web.health.base.PropertyStatus;

public interface Metrica extends JsonValue {
    String name();

    String description();

    String type();

    PropertyStatus status();

    long updateTs();

    void recalculateStatus();

    default float weight() {
        return 1.0f;
    }

    //CSOFF: MagicNumber
    //CSOFF: ReturnCount
    static String timeToHuman(final long mts) {
        long ts = mts;
        if (ts < 1000) {
            return String.valueOf(ts) + "ms";
        }
        long sec = ts / 1000;
        long ms = ts - (sec * 1000);
        long mins = sec / 60;
        if (mins <= 0) {
            return String.valueOf(sec) + "s " + String.valueOf(ms) + "ms";
        }

        sec -= mins * 60;
        long hours = mins / 60;

        if (hours <= 0) {
            return String.valueOf(mins) + "mins "
                + String.valueOf(sec) + '.'
                + String.valueOf(ms) + 's';
        }

        mins -= hours * 60;
        long days = hours / 24;
        if (days <= 0) {
            return String.valueOf(hours) + "h " + String.valueOf(mins) + "mins";
        }

        if (days > 1000) {
            return "Never";
        }

        return String.valueOf(days) + "days " + String.valueOf(hours) + 'h';
    }

    default void write(final JsonWriterBase writer) throws IOException {
        recalculateStatus();

        writer.key("name");
        writer.value(name());
        writer.key("type");
        writer.value(type());
        writer.key("status");
        writer.value(status());
        writer.key("description");
        writer.value(description());
        writer.key("updated");
        long diffMs = System.currentTimeMillis() - updateTs();
        writer.value(timeToHuman(diffMs));
        writer.key("updatedSecs");
        writer.value(TimeUnit.MILLISECONDS.toSeconds(diffMs));
    }

    default void writeValue(final JsonWriterBase writer) throws IOException {
        writer.startObject();
        write(writer);
        writer.endObject();
    }
    //CSOFF: MagicNumber
    //CSOFF: ReturnCount
}
