package ru.yandex.mail.search.web.health;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;

import ru.yandex.logger.PrefixedLogger;
import ru.yandex.mail.search.web.health.update.MetricUpdateTask;

public class SequentialTasksManager implements Runnable {
    private final List<MetricUpdateTask> tasks;
    private final PrefixedLogger logger;
    private volatile boolean cancelled = false;
    private final AtomicReference<MetricUpdateTask> running =
        new AtomicReference<>();
    private final String name;

    public SequentialTasksManager(
        final String name,
        final List<MetricUpdateTask> tasks,
        final PrefixedLogger logger)
    {
        this.tasks = tasks;
        this.logger = logger.addPrefix(name);
        this.name = name;
    }

    @Override
    public void run() {
        for (MetricUpdateTask task : tasks) {
            try {
                running.set(task);
                task.run();
                if (cancelled) {
                    logger.info("Manager cancelled");
                    break;
                }
            } catch (Exception e) {
                logger.log(
                    Level.WARNING,
                    "Metric update failed for " + task.name(),
                    e);
            }
        }
    }

    public void cancel() {
        cancelled = true;
        MetricUpdateTask task = running.get();
        if (task != null) {
            task.cancel();
        }
    }

    public void name() {

    }
}
