package ru.yandex.mail.search.web.health;

import java.util.ArrayList;
import java.util.List;

import ru.yandex.mail.search.web.health.base.PropertyStatus;

public class ShardMetrica implements Metrica {
    private final List<Metrica> replicaMetrics;
    private final String name;
    private final String type;
    private final float weight;
    private float score = 0;
    private long updateTs;
    private String description;
    private PropertyStatus status;

    public ShardMetrica(final String name, final String type) {
        this.replicaMetrics = new ArrayList<>();

        this.name = name;
        this.type = type;
        this.weight = weightByType(type);
    }

    public synchronized void add(final Metrica metrica) {
        replicaMetrics.add(metrica);
    }

    @Override
    public String name() {
        return name;
    }

    @Override
    public String description() {
        recalculateStatus();
        return description;
    }

    @Override
    public String type() {
        return type;
    }

    @Override
    public PropertyStatus status() {
        recalculateStatus();
        return status;
    }

    @Override
    public long updateTs() {
        long min = Long.MAX_VALUE;
        for (Metrica metrica: replicaMetrics) {
            if (metrica.updateTs() < min) {
                min = metrica.updateTs();
            }
        }

        return min;
    }

    @Override
    public synchronized void recalculateStatus() {
        float score = 0;
        for (Metrica metrica: replicaMetrics) {
            metrica.recalculateStatus();
            PropertyStatus status = metrica.status();
            if (status == PropertyStatus.WARNING) {
                score += 0.5f;
            }

            if (status == PropertyStatus.OK) {
                score += 1;
            }
        }

        if (score == 0) {
            this.status = PropertyStatus.ERROR;
        } else if (score == 1) {
            this.status = PropertyStatus.WARNING;
        } else {
            this.status = PropertyStatus.OK;
        }

        this.score = score;
        this.description =
            "Alive " + String.valueOf(score) + '/' + replicaMetrics.size();
    }

    public float errorScore() {
        recalculateStatus();
        return replicaMetrics.size() - score;
    }

    private static float weightByType(final String type) {
        if ("Peach".equalsIgnoreCase(type)) {
            return 0.5f;
        }

        return 1.0f;
    }
}
