package ru.yandex.mail.search.web.health.base;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import ru.yandex.mail.search.web.searchmap.MailSearchHost;
import ru.yandex.mail.search.web.searchmap.SearchmapShardGroup;

public class ProjectQueue {
    private final List<SearchmapShardGroup> shardGroups;
    private final String service;
    private final ProjectRoot psProject;
    private final List<ShardGroup> groups;

    public ProjectQueue(
        final List<SearchmapShardGroup> shardGroups,
        final String service,
        final ProjectRoot projectRoot)
    {
        this.shardGroups = shardGroups;
        this.service = service;
        this.psProject = projectRoot;

        List<ShardGroup> groups = new ArrayList<>();
        for (SearchmapShardGroup node: shardGroups) {
            ShardGroup shardGroup = new ShardGroup(this, node);
            groups.add(shardGroup);
        }

        this.groups = Collections.unmodifiableList(groups);
    }

    public String service() {
        return service;
    }

    public ProjectRoot projectRoot() {
        return psProject;
    }

    public List<ShardGroup> groups() {
        return groups;
    }

    // FixMe
    public Shard shard(final int id) {
        for (ShardGroup group: groups) {
            Shard shard = group.shard(id);
            if (shard != null) {
                return shard;
            }
        }

        return null;
    }

    // FixMe
    public List<ShardGroup> shardsByHost(final String host) {
        List<ShardGroup> result = new ArrayList<>();
        for (ShardGroup group: groups) {
            for (MailSearchHost mailSearchHost: group.node().hosts()) {
                if (mailSearchHost.hostname().equalsIgnoreCase(host)) {
                    result.add(group);
                    break;
                }
            }
        }

        return result;
    }
}
