package ru.yandex.mail.search.web.health.base;

import java.io.IOException;
import java.util.Locale;

import ru.yandex.mail.search.web.DefaultPsProject;
import ru.yandex.mail.search.web.WebApi;
import ru.yandex.mail.search.web.WebtoolsProject;
import ru.yandex.mail.search.web.config.AbstractPsProjectConfigBuilder;
import ru.yandex.mail.search.web.config.ImmutablePsProjectConfig;
import ru.yandex.mail.search.web.config.PsProjectConfig;
import ru.yandex.mail.search.web.config.PsProjectConfigBuilder;
import ru.yandex.mail.search.web.config.mail.ImmutableMailSearchConfig;
import ru.yandex.mail.search.web.config.mail.MailSearchConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.ps.webtools.aceventura.AceventuraProject;
import ru.yandex.ps.webtools.aceventura.AceventuraProjectConfig;
import ru.yandex.ps.webtools.aceventura.AceventuraProjectConfigBuilder;
import ru.yandex.ps.webtools.aceventura.ImmutableAceventuraProjectConfig;
import ru.yandex.ps.webtools.disk.DiskWebtoolsProject;
import ru.yandex.ps.webtools.mail.MailSearchProject;

public enum PsProjectType {
    DISK_SEARCH {
        @Override
        public WebtoolsProject project(
                final WebApi webApi, final ImmutablePsProjectConfig config)
                throws IOException
        {
            return new DiskWebtoolsProject(
                    webApi,
                    this,
                    config);
        }
    },
    MAIL_SEARCH {
        @Override
        public AbstractPsProjectConfigBuilder<? extends PsProjectConfig>
        configBuilder(
            final IniConfig config) throws ConfigException
        {
            return new MailSearchConfigBuilder(config);
        }

        @Override
        public AbstractPsProjectConfigBuilder<? extends PsProjectConfig> configBuilder(
            final PsProjectConfig config)
        {
            return new MailSearchConfigBuilder(config);
        }

        @Override
        public WebtoolsProject project(
            final WebApi webApi, final ImmutablePsProjectConfig config)
            throws IOException
        {
            return new MailSearchProject(
                webApi,
                this,
                (ImmutableMailSearchConfig) config);
        }
    },
    CONTACTS_SEARCH {
        @Override
        public AbstractPsProjectConfigBuilder<? extends PsProjectConfig>
        configBuilder(
            final IniConfig config) throws ConfigException
        {
            return new AceventuraProjectConfigBuilder(config);
        }

        @Override
        public AbstractPsProjectConfigBuilder<? extends PsProjectConfig> configBuilder(
            final PsProjectConfig config)
        {
            return new AceventuraProjectConfigBuilder((AceventuraProjectConfig) config);
        }

        @Override
        public WebtoolsProject project(
            final WebApi webApi,
            final ImmutablePsProjectConfig config)
            throws IOException
        {
            return new AceventuraProject(
                webApi,
                this,
                (ImmutableAceventuraProjectConfig) config);
        }
    },
    DISTRICT_SEARCH,
    MESSENGER_SEARCH;

    private final String lowName;

    PsProjectType() {
        lowName = name().toLowerCase(Locale.ENGLISH);
    }

    public AbstractPsProjectConfigBuilder<? extends PsProjectConfig> configBuilder(
        final IniConfig config)
        throws ConfigException
    {
        return new PsProjectConfigBuilder(config);
    }

    public AbstractPsProjectConfigBuilder<? extends PsProjectConfig> configBuilder(
        final PsProjectConfig config)
    {
        return new PsProjectConfigBuilder(config);
    }

    public WebtoolsProject project(
        final WebApi webApi,
        final ImmutablePsProjectConfig config)
        throws IOException
    {
        return new DefaultPsProject(webApi, this, config);
    }

    public String lowName() {
        return lowName;
    }
}
