package ru.yandex.mail.search.web.health.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import ru.yandex.mail.search.web.health.Metrica;
import ru.yandex.mail.search.web.searchmap.SearchmapShardGroup;

/**
 * This is representation of iNum thing in searchmap. Group of shards
 * who a physically on one group of hosts;
 *
 */
public class ShardGroup {
    private final String id;
    private final ProjectQueue queue;
    private final SearchmapShardGroup node;
    private final Map<Integer, Shard> shards;
    private final List<Metrica> metrics;

    public ShardGroup(
        final ProjectQueue queue,
        final SearchmapShardGroup node)
    {
        this.queue = queue;
        this.node = node;
        this.id = String.valueOf(node.iNum());

        Map<Integer, Shard> shards = new LinkedHashMap<>();
        for (Integer shardId: node.shards()) {
            Shard shard = new Shard(this, shardId, node);
            shards.put(shardId, shard);
        }

        this.shards = Collections.unmodifiableMap(shards);
        this.metrics = new ArrayList<>();
    }

    public String id() {
        return id;
    }

    public ProjectQueue queue() {
        return queue;
    }

    public SearchmapShardGroup node() {
        return node;
    }

    public Collection<Shard> shards() {
        return shards.values();
    }

    public Shard shard(final int shardId) {
        return shards.get(shardId);
    }

    public List<Metrica> metrics() {
        return metrics;
    }

    public void addMetric(final Metrica metric) {
        this.metrics.add(metric);
    }
}
