package ru.yandex.mail.search.web.health.base;

import java.util.ArrayList;
import java.util.List;

import ru.yandex.mail.search.web.health.Metrica;
import ru.yandex.mail.search.web.searchmap.MailSearchHost;

public final class ShardReplica {
    private final List<Metrica> metrics;

    private final Shard shard;
    private final MailSearchHost host;

    public ShardReplica(final Shard shard, final MailSearchHost host) {
        this.shard = shard;
        this.host = host;
        this.metrics = new ArrayList<>();
    }

    public List<Metrica> metrics() {
        return metrics;
    }

    public Shard shard() {
        return shard;
    }

    public MailSearchHost host() {
        return host;
    }

    public void addMetric(final Metrica property) {
        this.metrics.add(property);
        this.shard.addReplicaMetric(property);
    }
}
