package ru.yandex.mail.search.web.health.update;

public abstract class AbstractCheckTask implements MetricUpdateTask {
    private static final long DEFAULT_TIMEOUT = 300000;
    private final long timeout;
    private long startTime = -1;

    public AbstractCheckTask() {
        this(DEFAULT_TIMEOUT);
    }

    public AbstractCheckTask(final long timeout) {
        this.timeout = timeout;
    }

    @Override
    public synchronized void run() {
        long currentTime = System.currentTimeMillis();
        if (startTime > 0 && currentTime - startTime > timeout) {
            timedout();

            startTime = -1L;
        }

        if (startTime < 0) {
            startTime = currentTime;
            start();
        }
    }

    protected abstract void start();

    protected abstract void timedout();
}
