package ru.yandex.mail.search.web.info;

import java.util.AbstractMap;
import java.util.Map;
import java.util.logging.Level;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.json.dom.BasicContainerFactory;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.dom.JsonString;
import ru.yandex.logger.PrefixedLogger;
import ru.yandex.parser.uri.CgiParams;
import ru.yandex.ps.webtools.mail.MailSearchExtractSession;
import ru.yandex.ps.webtools.mail.MailSearchProject;
import ru.yandex.search.proxy.SearchProxyParams;

public abstract class AbstractMailExtractFactory
    implements InfoExtractorFactory
{
    protected MailSearchProject project;

    public AbstractMailExtractFactory(final MailSearchProject project) {
        this.project = project;
    }

    protected MailSearchExtractSession prepare(
        final String name,
        final ProxySession session,
        final FutureCallback<Map.Entry<String, JsonObject>> callback)
    {
        MailSearchExtractSession extractSession = null;
        try {
            if (!session.params().getBoolean(name, false)) {
                callback.completed(null);
                return null;
            }

            String text =
                session.params().getString("request", "");
            String mid = session.params().getString(
                InfoHandler.MID,
                null);
            Long uid = session.params().getLong(
                InfoHandler.UID,
                null);

            PrefixedLogger logger = session.logger().addPrefix("MailLucene");
            logger.info("Request " + text);
            if (uid == null) {
                String uidStr = UID_EXTRACT_CHAIN.extract(text);

                if (uidStr != null) {
                    uid = Long.parseLong(uidStr);
                }
            }

            if (uid == null) {
                throw new BadRequestException("Failed to extract uid");
            }

            if (mid == null) {
                mid = MID_EXTRACT_CHAIN.extract(text);
            }

            if (mid == null) {
                throw new BadRequestException("Failed to extract mid");
            }

            String defaultService = project.config().mainQueue();

            String service =
                InfoExtractorFactory.SERVICE_EXTRACT_CHAIN.extract(text);
            if (service == null) {
                service = defaultService;
            }

            CgiParams params = new CgiParams(session.params());
            params.replace(InfoHandler.UID, uid.toString());
            params.replace(InfoHandler.MID, mid);
            params.replace(SearchProxyParams.SERVICE, service);

            extractSession =
                new MailSearchExtractSession(project, session, params);
        } catch (BadRequestException | NumberFormatException bre) {
            session.logger().log(
                Level.WARNING,
                "Failed to init MailLuceneExtractor",
                bre);

            JsonMap root = new JsonMap(BasicContainerFactory.INSTANCE);
            root.put("error", new JsonString(bre.toString()));
            callback.completed(
                new AbstractMap.SimpleEntry<>(InfoHandler.LUCENE, root));
        }

        return extractSession;
    }
}
