package ru.yandex.mail.search.web.info;

import java.util.AbstractMap;
import java.util.Map;
import java.util.logging.Level;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.json.dom.BasicContainerFactory;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.dom.JsonString;
import ru.yandex.logger.PrefixedLogger;
import ru.yandex.parser.uri.CgiParams;
import ru.yandex.ps.webtools.mail.MailSearchExtractSession;
import ru.yandex.ps.webtools.mail.MailSearchProject;
import ru.yandex.search.proxy.SearchProxyParams;

public class CheckIndexExtractorFactory implements InfoExtractorFactory {
    private static final ExtractChain UID_EXTRACT_CHAIN =
        new PatternExtractChain(
            ONE_LONG,
            InfoExtractorFactory.UID_EXTRACT_CHAIN);

    private final MailSearchProject webApi;

    public CheckIndexExtractorFactory(final MailSearchProject webApi) {
        this.webApi = webApi;
    }

    @Override
    public void create(
        final ProxySession session,
        final FutureCallback<Map.Entry<String, JsonObject>> callback)
    {
        PrefixedLogger logger = session.logger().addPrefix("CheckIndex");
        MailSearchExtractSession extractSession = null;
        try {
            if (!session.params().getBoolean(
                InfoHandler.CHECKINDEX,
                false))
            {
                callback.completed(null);
                return;
            }

            String text =
                session.params().getString("request", "");

            Long uid = session.params().getLong(
                InfoHandler.UID,
                null);

            logger.info("Request " + text);
            if (uid == null) {
                String uidStr = UID_EXTRACT_CHAIN.extract(text);

                if (uidStr != null) {
                    uid = Long.parseLong(uidStr);
                }
            }

            if (uid == null) {
                throw new BadRequestException("Failed to extract uid");
            }

            String defaultService = webApi.config().mainQueue();

            String service =
                InfoExtractorFactory.SERVICE_EXTRACT_CHAIN.extract(text);

            if (service == null) {
                service = defaultService;
            }

            CgiParams params = new CgiParams(session.params());
            params.replace(InfoHandler.UID, uid.toString());
            params.replace(SearchProxyParams.SERVICE, service);

            extractSession = new MailSearchExtractSession(webApi, session, params);
            new CheckIndexExtractor(extractSession, callback).execute();
        } catch (BadRequestException | NumberFormatException bre) {
            logger.log(
                Level.WARNING,
                "Failed to init CheckIndexExtractor",
                bre);

            JsonMap root = new JsonMap(BasicContainerFactory.INSTANCE);
            root.put("error", new JsonString(bre.toString()));
            callback.completed(
                new AbstractMap.SimpleEntry<>(InfoHandler.LUCENE, root));
        }
    }
}
