package ru.yandex.mail.search.web.info;

public abstract class ExtractChain {
    private final ExtractChain next;

    public ExtractChain(final ExtractChain next) {
        this.next = next;
    }

    protected abstract String doExtract(final String text);

    public String extract(final String text) {
        String result = null;
        if (next != null) {
            result = next.extract(text);
        }

        if (result == null) {
            result = doExtract(text);
        }

        return result;
    }
}
