package ru.yandex.mail.search.web.info;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.mail.search.web.Enviroment;
import ru.yandex.mail.search.web.WebtoolsProject;
import ru.yandex.parser.searchmap.SearchMap;
import ru.yandex.parser.uri.CgiParams;

public class ExtractSession {
    private final WebtoolsProject project;
    private final ProxySession session;
    private final CgiParams params;

    private final Enviroment enviroment;

    public ExtractSession(
        final WebtoolsProject project,
        final ProxySession session,
        final CgiParams params)
        throws BadRequestException
    {
        this.project = project;
        this.session = session;
        this.params = params;

        enviroment =
            params.getEnum(Enviroment.class, "env", Enviroment.PROD);
    }

    public WebtoolsProject project() {
        return project;
    }

    public ProxySession session() {
        return session;
    }

    public CgiParams params() {
        return params;
    }

    public Enviroment enviroment() {
        return enviroment;
    }

    public SearchMap searchMap() {
        return project.searchmap();
    }
}
