package ru.yandex.mail.search.web.info;

import java.util.Map;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.util.BadRequestException;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.ps.webtools.mail.MailSearchExtractSession;

public class FactsExtractor extends MailLuceneExtractor {
    public FactsExtractor(
        final MailSearchExtractSession session,
        final FutureCallback<Map.Entry<String, JsonObject>> callback)
        throws BadRequestException
    {
        super(session, callback);
    }

    @Override
    protected String name() {
        return InfoHandler.FACTS;
    }

    @Override
    protected String uri() {
        return "/search?prefix=" + user.prefix()
            + "&service=" + user.service()
            + "&get=*&text=fact_mid:" + mid;
    }
}
