package ru.yandex.mail.search.web.info;

import java.util.AbstractMap;
import java.util.Map;
import java.util.logging.Level;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.json.dom.BasicContainerFactory;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.dom.JsonString;
import ru.yandex.ps.webtools.mail.MailSearchExtractSession;
import ru.yandex.ps.webtools.mail.MailSearchProject;

public class FactsExtractorFactory extends AbstractMailExtractFactory {
    public FactsExtractorFactory(final MailSearchProject project) {
        super(project);
    }

    @Override
    public void create(
        final ProxySession session,
        final FutureCallback<Map.Entry<String, JsonObject>> callback)
    {
        MailSearchExtractSession extractSession =
            prepare(InfoHandler.FACTS, session, callback);
        if (extractSession != null) {
            session.logger().info("Executing filter_search");
            try {
                new FactsExtractor(extractSession, callback).execute();
            } catch (BadRequestException bre) {
                session.logger().log(
                    Level.WARNING,
                    "Failed to init MailLuceneExtractor",
                    bre);

                JsonMap root = new JsonMap(BasicContainerFactory.INSTANCE);
                root.put("error", new JsonString(bre.toString()));
                callback.completed(
                    new AbstractMap.SimpleEntry<>(InfoHandler.LUCENE, root));
            }
        }
    }
}
