package ru.yandex.mail.search.web.info;

import java.util.concurrent.TimeUnit;

import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;

import ru.yandex.dbfields.MailIndexFields;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.mail.search.web.config.mail.ImmutableMailSearchConfig;
import ru.yandex.parser.searchmap.User;
import ru.yandex.parser.uri.QueryConstructor;
import ru.yandex.search.document.mail.MailMetaInfo;
import ru.yandex.search.proxy.SearchProxyParams;

interface InfoExtractor {
    String BASE_URI =
        InfoHandler.BALANCER + "/ui/mail/search/info?";

    void execute();

    default String link(final String link, final String text) {
        return text + '\t' + link;
    }

    default String stidLink(final String stId) {
        QueryConstructor qc = new QueryConstructor(BASE_URI);
        try {
            qc.append(MailMetaInfo.STID, stId);
        } catch (BadRequestException bre) {
            bre.printStackTrace();
        }
        return link(stId, stId);
    }

    default String queueIdLink(final User user, final long queueId) {
        return queueIdLink(user, String.valueOf(queueId));
    }

    default String queueIdLink(final User user, final String queueId) {
        StringBuilder sb = new StringBuilder();
        sb.append(MailIndexFields.QUEUE_ID);
        sb.append('=');
        sb.append(queueId);
        sb.append('&');
        sb.append(SearchProxyParams.SERVICE);
        sb.append('=');
        sb.append(user.service());
        sb.append('&');
        sb.append(SearchProxyParams.PREFIX);
        sb.append('=');
        sb.append(user.prefix().toString());
        QueryConstructor qc = new QueryConstructor(BASE_URI);

        try {
            qc.append("request_text", sb.toString());
        } catch (BadRequestException bre) {
            bre.printStackTrace();
        }

        return link(qc.toString(), queueId);
    }

    default String unixtimestamp(final String ts) {
        try {
            return unixtimestamp(Double.parseDouble(ts));
        } catch (NumberFormatException nfe) {
            nfe.printStackTrace();
            return ts;
        }
    }

    default String unixtimestamp(final double ts) {
        DateTime dt = new DateTime(TimeUnit.SECONDS.toMillis((long) ts));
        StringBuilder sb = new StringBuilder();
        sb.append(dt.getMillis());
        sb.append(" (");
        sb.append(
            DateTimeFormat.forPattern("dd.MM.yy HH:mm:ss").print(dt));
        sb.append(')');
        return sb.toString();
    }

    default String service(
        final long uid,
        final ImmutableMailSearchConfig config)
    {
        return config.mainQueue();
    }
}
