package ru.yandex.mail.search.web.info;

import java.util.Map;
import java.util.regex.Pattern;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.json.dom.JsonObject;

public interface InfoExtractorFactory {
    Pattern UID_P = Pattern.compile("uid=(\\d+)");
    Pattern KPS_P = Pattern.compile("kps=(\\d+)");
    Pattern PREFIX_P = Pattern.compile("prefix=(\\d+)");
    Pattern MID_P = Pattern.compile("mid=(\\d+)");
    Pattern MID_WEB = Pattern.compile("#message/(\\d+)");
    Pattern ONE_LONG = Pattern.compile("^(\\d+)$");
    Pattern SERVICE_P = Pattern.compile("service=([a-zA-Z0-9_\\-]+)");

    ExtractChain UID_EXTRACT_CHAIN =
        new PatternExtractChain(
            KPS_P,
            new PatternExtractChain(
                PREFIX_P, new PatternExtractChain(UID_P, null)));

    ExtractChain MID_EXTRACT_CHAIN =
        new PatternExtractChain(
            MID_WEB,
            new PatternExtractChain(MID_P, null));

    ExtractChain SERVICE_EXTRACT_CHAIN =
        new PatternExtractChain(SERVICE_P, null);

    void create(
        final ProxySession session,
        final FutureCallback<Map.Entry<String, JsonObject>> callback);
}
