package ru.yandex.mail.search.web.info;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

import org.apache.http.HttpException;
import org.apache.http.HttpStatus;

import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.proxy.ProxyRequestHandler;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.MultiFutureCallback;
import ru.yandex.io.StringBuilderWriter;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonWriter;
import ru.yandex.ps.webtools.mail.MailSearchProject;

public class InfoHandler implements ProxyRequestHandler {
    public static final String UID = "uid";
    public static final String MID = "mid";

    public static final String BALANCER =
        "https://mail-search-tools.n.yandex-team.ru";

    protected static final String LUCENE = "lucene";
    protected static final String QUEUE = "queue";
    protected static final String FILTER_SEARCH = "filterSearch";
    protected static final String CHECKINDEX = "check-index";
    protected static final String FACTS = "facts";
    protected static final String HITS_ARRAY = "hitsArray";
    protected static final String HITS_COUNT = "hitsCount";

    private final List<InfoExtractorFactory> extractors;

    public InfoHandler(final MailSearchProject project) {
        this.extractors =
            Arrays.asList(
                new MailLuceneExtractorFactory(project),
                new QueueExtractorFactory(project),
                new FilterSearchExtractorFactory(project),
                new FactsExtractorFactory(project),
                new CheckIndexExtractorFactory(project));
    }

    @Override
    public void handle(
        final ProxySession session)
        throws HttpException, IOException
    {
        MultiFutureCallback<Map.Entry<String, JsonObject>> mfcb =
            new MultiFutureCallback<>(new InfoCallback(session));

        for (InfoExtractorFactory factory: extractors) {
            factory.create(session, mfcb.newCallback());
        }

        mfcb.done();
    }

    private static final class InfoCallback
        extends AbstractProxySessionCallback<
        List<Map.Entry<String, JsonObject>>>
    {
        private InfoCallback(final ProxySession session) {
            super(session);
        }

        @Override
        public void completed(final List<Map.Entry<String, JsonObject>> maps) {
            StringBuilderWriter sbw = new StringBuilderWriter();
            try (JsonWriter writer = JsonType.NORMAL.create(sbw)) {
                writer.startObject();
                for (Map.Entry<String, JsonObject> entry : maps) {
                    if (entry != null) {
                        writer.key(entry.getKey());
                        writer.value(entry.getValue());
                    }
                }
                writer.endObject();
            } catch (IOException e) {
                failed(e);
                return;
            }

            session.response(HttpStatus.SC_OK, sbw.toString());
        }
    }
}
