package ru.yandex.mail.search.web.info;

import java.util.logging.Level;

import org.apache.http.HttpHost;
import org.apache.http.concurrent.FutureCallback;

import ru.yandex.search.result.SearchResult;

final class LoggingLuceneCallback
    implements FutureCallback<SearchResult>
{
    private final HttpHost host;
    private final ExtractSession session;
    private final FutureCallback<SearchResult> wrapped;

    LoggingLuceneCallback(
        final HttpHost host,
        final ExtractSession session,
        final FutureCallback<SearchResult> wrapped)
    {
        if (host == null) {
            this.host = new HttpHost("anyhost");
        } else {
            this.host = host;
        }

        this.session = session;
        this.wrapped = wrapped;
    }

    @Override
    public void completed(final SearchResult result) {
        session.session().logger().info(
            "Lucene completed for " + result.host()
                + ' ' + result.hitsCount()
                + ' ' + result.hitsArray());
        wrapped.completed(result);
    }

    @Override
    public void failed(final Exception e) {
        session.session().logger().log(
            Level.WARNING,
            "Lucene failed",
            e);
        wrapped.completed(new SearchResultFailed(host, e));
    }

    @Override
    public void cancelled() {
        wrapped.cancelled();
    }
}
