package ru.yandex.mail.search.web.info;

import java.util.AbstractMap;
import java.util.Map;
import java.util.logging.Level;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.json.dom.BasicContainerFactory;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.dom.JsonString;
import ru.yandex.ps.webtools.mail.MailSearchExtractSession;
import ru.yandex.ps.webtools.mail.MailSearchProject;

public class MailLuceneExtractorFactory extends AbstractMailExtractFactory {
    public MailLuceneExtractorFactory(final MailSearchProject webApi) {
        super(webApi);
    }

    @Override
    public void create(
        final ProxySession session,
        final FutureCallback<Map.Entry<String, JsonObject>> callback)
    {
        MailSearchExtractSession extractSession =
            prepare("lucene", session, callback);
        if (extractSession != null) {
            try {
                new MailLuceneExtractor(extractSession, callback).execute();
            } catch (BadRequestException bre) {
                session.logger().log(
                    Level.WARNING,
                    "Failed to init MailLuceneExtractor",
                    bre);

                JsonMap root = new JsonMap(BasicContainerFactory.INSTANCE);
                root.put("error", new JsonString(bre.toString()));
                callback.completed(
                    new AbstractMap.SimpleEntry<>(InfoHandler.LUCENE, root));
            }
        }
    }
}
