package ru.yandex.mail.search.web.info;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PatternExtractChain extends ExtractChain {
    private final Pattern pattern;

    public PatternExtractChain(
        final Pattern pattern,
        final ExtractChain next)
    {
        super(next);

        this.pattern = pattern;
    }

    @Override
    protected String doExtract(final String text) {
        Matcher matcher = pattern.matcher(text);
        if (matcher.find() && matcher.groupCount() > 0) {
            return matcher.group(1);
        }

        return null;
    }
}
