package ru.yandex.mail.search.web.info;

import java.util.Collections;
import java.util.List;

import org.apache.http.HttpHost;

import ru.yandex.search.result.BasicSearchDocument;
import ru.yandex.search.result.SearchDocument;
import ru.yandex.search.result.SearchResult;

public class SearchResultFailed implements SearchResult {
    private final HttpHost host;
    private final SearchDocument document;

    public SearchResultFailed(
        final HttpHost host,
        final Exception exception)
    {
        this.host = host;
        document = new BasicSearchDocument();
        document.attrs().put("Search Error", exception.toString());
    }

    @Override
    public HttpHost host() {
        return host;
    }

    @Override
    public long hitsCount() {
        return -1;
    }

    @Override
    public List<SearchDocument> hitsArray() {
        return Collections.singletonList(document);
    }

    @Override
    public long zooQueueId() {
        return -1L;
    }
}
