package ru.yandex.mail.search.web.mail.checkindex;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

import org.apache.http.HttpStatus;

import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.io.StringBuilderWriter;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonTypeExtractor;
import ru.yandex.json.writer.JsonWriter;

public class CheckIndexCallback
    extends AbstractProxySessionCallback<Object>
{
    private final JsonType jsonType;
    private final LinkedHashSet<String> columns;
    private final List<ResultRow> rows;

    public CheckIndexCallback(
        final ProxySession session)
        throws BadRequestException
    {
        super(session);

        jsonType = JsonTypeExtractor.NORMAL.extract(session.params());
        rows = new ArrayList<>();
        columns = new LinkedHashSet<>();
    }

    @Override
    public void completed(final Object object) {
        List<ResultRow> rows;
        LinkedHashSet<String> columns;
        synchronized (this) {
            rows = new ArrayList<>(this.rows);
            columns = new LinkedHashSet<>(this.columns);
        }

        Collections.sort(rows);

        StringBuilderWriter sbw = new StringBuilderWriter();
        try (JsonWriter writer = jsonType.create(sbw)) {
            writer.startObject();
            writer.key("titles");
            writer.value(columns);
            writer.key("values");
            writer.value(rows);
            writer.endObject();
        } catch (IOException e) {
            failed(e);
            return;
        }

        session.response(HttpStatus.SC_OK, sbw.toString());
    }

    public synchronized void addRow(
        final RowType rowType,
        final Map<String, Object> values)
    {
        columns.addAll(values.keySet());
        ResultRow row = new ResultRow(rowType);

        for (String column: columns) {
            row.add(values.getOrDefault(column, ""));
        }

        this.rows.add(row);
    }
}
