package ru.yandex.mail.search.web.mail.checkindex;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import ru.yandex.json.writer.JsonValue;
import ru.yandex.json.writer.JsonWriterBase;

public class ResultRow implements Comparable<ResultRow>, JsonValue {
    private final RowType rowType;
    private final List<Object> values;

    public ResultRow(final RowType rowType) {
        this.rowType = rowType;
        this.values = new ArrayList<>();
    }

    public void add(final Object value) {
        values.add(value);
    }

    @Override
    public int compareTo(final ResultRow o) {
        int result = rowType.compareTo(o.rowType);
        if (result == 0 && values.size() > 0 && o.values.size() > 0) {
            result =
                values.get(0).toString().compareTo(o.values.get(0).toString());
        }

        return result;
    }

    @Override
    public void writeValue(final JsonWriterBase writer) throws IOException {
        writer.value(values);
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResultRow)) {
            return false;
        }

        ResultRow resultRow = (ResultRow) o;

        if (rowType != resultRow.rowType) {
            return false;
        }
        return values.equals(resultRow.values);
    }

    @Override
    public int hashCode() {
        int result = rowType.hashCode();
        result = result + values.hashCode();
        return result;
    }
}
