package ru.yandex.mail.search.web.mail.checkindex.lucene;

import org.apache.http.HttpHost;
import org.apache.http.concurrent.FutureCallback;

import ru.yandex.search.result.SearchResult;

public final class LuceneCallback
    implements FutureCallback<SearchResult>
{
    private final HttpHost host;
    private final FutureCallback<LuceneDocsCountHostResult> callback;

    public LuceneCallback(
        final HttpHost host,
        final FutureCallback<LuceneDocsCountHostResult> callback)
    {
        this.callback = callback;
        this.host = host;
    }

    @Override
    public void completed(final SearchResult result) {
        callback.completed(
            new LuceneDocsCountHostResult(host, result.hitsCount()));
    }

    @Override
    public void failed(final Exception e) {
        callback.completed(
            new LuceneDocsCountHostResult(host, e));
    }

    @Override
    public void cancelled() {
        callback.completed(
            new LuceneDocsCountHostResult(host, new Exception("cancelled")));
    }
}
