package ru.yandex.mail.search.web.mail.checkindex.lucene;

import org.apache.http.HttpHost;

public class LuceneDocsCountHostResult {
    private static final String RUNTIME_POSTFIX = ".search.yandex.net";
    private static final String MTN_POSTFIX = ".gencfg-c.yandex.net";
    private final HttpHost host;
    private final String shortHostname;
    private final long docsCount;
    private final Exception exception;

    public LuceneDocsCountHostResult(
        final HttpHost host,
        final long docsCount)
    {
        this.host = host;
        this.docsCount = docsCount;
        this.exception = null;
        this.shortHostname = trimHostname(host);
    }

    public LuceneDocsCountHostResult(
        final HttpHost host,
        final Exception exception)
    {
        this.host = host;
        this.exception = exception;
        this.docsCount = -1L;
        this.shortHostname = trimHostname(host);
    }

    public boolean ok() {
        return exception == null;
    }

    public HttpHost host() {
        return host;
    }

    public long docsCount() {
        return docsCount;
    }

    public Exception exception() {
        return exception;
    }

    public String shortHostname() {
        return shortHostname;
    }

    private static String trimHostname(final HttpHost host) {
        String name = host.getHostName();
        if (name.endsWith(RUNTIME_POSTFIX)) {
            name = name.substring(0, name.length() - RUNTIME_POSTFIX.length());
        } else if (name.endsWith(MTN_POSTFIX)) {
            String[] split = name.split("-");
            if (split.length >= 2) {
                name = split[0] + '-' + split[1];
            }
        }

        return name;
    }
}
