package ru.yandex.mail.search.web.mail.checkindex.lucene;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.apache.http.HttpHost;
import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.MultiFutureCallback;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.mail.search.web.mail.checkindex.CheckIndexHandler;
import ru.yandex.mail.search.web.mail.checkindex.CheckIndexSession;
import ru.yandex.mail.search.web.mail.checkindex.MdbFoldersDocs;
import ru.yandex.mail.search.web.mail.checkindex.RowType;
import ru.yandex.search.proxy.SearchResultConsumerFactory;

public class LuceneFastDocsTotalCheck implements LuceneIndexCheck {
    public LuceneFastDocsTotalCheck() {
    }

    public void check(
        final CheckIndexSession session,
        final MdbFoldersDocs dbDocs,
        final MultiFutureCallback<Object> mfcb)
        throws BadRequestException
    {
        if (!session.params().getBoolean("total", false)) {
            return;
        }

        List<HttpHost> hosts =
            session.webApi().searchmap().searchHosts(session.user());

        MultiFutureCallback<LuceneDocsCountHostResult> luceneMfcb =
            new MultiFutureCallback<>(
                new TotalFastCallback(session, dbDocs, mfcb.newCallback()));

        for (HttpHost host: hosts) {
            session.searchClient().execute(
                host,
                new BasicAsyncRequestProducerGenerator(
                    session.luceneBase() + "&length=1&text=hid:0"),
                SearchResultConsumerFactory.INSTANCE,
                session.contextSupplier(),
                new LuceneCallback(host, luceneMfcb.newCallback()));
        }

        luceneMfcb.done();
    }

    private static final class TotalFastCallback
        implements FutureCallback<List<LuceneDocsCountHostResult>>
    {
        private final CheckIndexSession session;
        private final FutureCallback<Object> callback;
        private final MdbFoldersDocs dbDocs;

        private TotalFastCallback(
            final CheckIndexSession session,
            final MdbFoldersDocs dbDocs,
            final FutureCallback<Object> callback)
        {
            this.session = session;
            this.callback = callback;
            this.dbDocs = dbDocs;
        }

        @Override
        public void completed(final List<LuceneDocsCountHostResult> entries) {
            Map<String, Object> row = new LinkedHashMap<>();
            row.put("#", "Total");
            row.put("DB", dbDocs.total());

            for (LuceneDocsCountHostResult entry: entries) {
                if (entry.ok()) {
                    row.put(entry.shortHostname(),
                        CheckIndexHandler.printWithDiff(
                            dbDocs.total(),
                            entry.docsCount()));
                } else {
                    row.put(
                        entry.shortHostname(),
                        entry.exception().getMessage());
                }
            }

            session.callback().addRow(RowType.TOTAL, row);
            callback.completed(null);
        }

        @Override
        public void failed(final Exception e) {
            callback.completed(null);
        }

        @Override
        public void cancelled() {
            callback.completed(null);
        }
    }
}
