package ru.yandex.mail.search.web.mail.checkindex.lucene;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.apache.http.HttpHost;
import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.MultiFutureCallback;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.mail.search.web.mail.checkindex.CheckIndexSession;
import ru.yandex.mail.search.web.mail.checkindex.MdbFoldersDocs;
import ru.yandex.mail.search.web.mail.checkindex.RowType;
import ru.yandex.search.proxy.SearchResultConsumerFactory;

public class LucenePeachDocsCheck implements LuceneIndexCheck {
    private static final int MAGIC_SHARDS = 65534;

    public LucenePeachDocsCheck() {
    }

    @Override
    public void check(
        final CheckIndexSession session,
        final MdbFoldersDocs docs,
        final MultiFutureCallback<Object> mfcb)
        throws BadRequestException
    {
        if (!session.params().getBoolean("peach", false)) {
            return;
        }

        long shard = session.uid() % MAGIC_SHARDS;

        List<HttpHost> hosts =
            session.webApi().searchmap().searchHosts(session.user());

        MultiFutureCallback<LuceneDocsCountHostResult> luceneMfcb =
            new MultiFutureCallback<>(
                new PeachCallback(session, mfcb.newCallback()));

        String request =
            "/search?get=peach_sequence&length=0&service="
                + session.user().service()
                + "&prefix=" + shard
                + "&text=peach_url:uid=" + session.uid();

        for (HttpHost host: hosts) {
            session.searchClient().execute(
                host,
                new BasicAsyncRequestProducerGenerator(request),
                SearchResultConsumerFactory.INSTANCE,
                session.contextSupplier(),
                new LuceneCallback(host, luceneMfcb.newCallback()));
        }

        luceneMfcb.done();
    }

    private static final class PeachCallback
        implements FutureCallback<List<LuceneDocsCountHostResult>>
    {
        private final CheckIndexSession session;
        private final FutureCallback<Object> callback;

        private PeachCallback(
            final CheckIndexSession session,
            final FutureCallback<Object> callback)
        {
            this.session = session;
            this.callback = callback;
        }

        @Override
        public void completed(final List<LuceneDocsCountHostResult> entries) {
            Map<String, Object> row = new LinkedHashMap<>();
            row.put("#", "Peach");
            row.put("DB", "");

            for (LuceneDocsCountHostResult entry: entries) {
                if (entry.ok()) {
                    row.put(entry.shortHostname(), entry.docsCount());
                } else {
                    row.put(
                        entry.shortHostname(),
                        entry.exception().getMessage());
                }
            }

            session.callback().addRow(RowType.PEACH, row);
            callback.completed(null);
        }

        @Override
        public void failed(final Exception e) {
            callback.completed(null);
        }

        @Override
        public void cancelled() {
            callback.completed(null);
        }
    }
}
