package ru.yandex.mail.search.web.searchmap;

import java.io.IOException;

import org.apache.http.HttpException;
import org.apache.http.HttpStatus;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;

import ru.yandex.http.proxy.ProxyRequestHandler;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.io.StringBuilderWriter;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonTypeExtractor;
import ru.yandex.json.writer.JsonWriter;

public class ListServicesHandler implements ProxyRequestHandler {
    private final SearchmapHelper helper;

    public ListServicesHandler(
        final SearchmapHelper helper)
    {
        this.helper = helper;
    }

    @Override
    public void handle(final ProxySession session)
        throws HttpException, IOException
    {
        JsonType jsonType = JsonTypeExtractor.NORMAL.extract(session.params());
        StringBuilderWriter sbw = new StringBuilderWriter();
        try (JsonWriter jw = jsonType.create(sbw)) {
            jw.value(helper.services());
        }

        session.response(
            HttpStatus.SC_OK,
            new StringEntity(sbw.toString(), ContentType.APPLICATION_JSON));
    }
}
