package ru.yandex.mail.search.web.searchmap;

import java.io.IOException;

import ru.yandex.json.writer.JsonValue;
import ru.yandex.json.writer.JsonWriterBase;
import ru.yandex.parser.searchmap.SearchMapHost;

public class MailSearchHost implements JsonValue {
    private final String hostName;
    private final int basePort;
    private final int searchPort;
    private final int indexerPort;
    private final int kamajiPort;
    private final int ljinxPort;
    private final int peachPort;
    private final int dumpPort;
    private final int consumerPort;

    // CSOFF: MagicNumber
    public MailSearchHost(final SearchMapHost host) {
        this.hostName = host.searchHost().getHostName();
        this.searchPort = host.searchHost().getPort();
        this.indexerPort = host.indexerHost().getPort();
        this.basePort = host.searchHost().getPort() - 1;
        this.kamajiPort = basePort + 4;
        this.ljinxPort = basePort + 5;
        this.peachPort = basePort + 7;
        this.dumpPort = basePort + 6;
        this.consumerPort = basePort + 3;
    }
    // CSON: MagicNumber

    public String hostname() {
        return hostName;
    }

    public int dumpPort() {
        return dumpPort;
    }

    public int searchPort() {
        return searchPort;
    }

    public int indexerPort() {
        return indexerPort;
    }

    public int kamajiPort() {
        return kamajiPort;
    }

    public int ljinxPort() {
        return ljinxPort;
    }

    public int peachPort() {
        return peachPort;
    }

    public int basePort() {
        return basePort;
    }

    public int consumerPort() {
        return consumerPort;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MailSearchHost)) {
            return false;
        }

        MailSearchHost host = (MailSearchHost) o;

        if (basePort != host.basePort) {
            return false;
        }
        return hostName.equals(host.hostName);
    }

    @Override
    public int hashCode() {
        int result = hostName.hashCode();
        result = 31 * result + basePort;
        return result;
    }

    @Override
    public void writeValue(final JsonWriterBase writer) throws IOException {
        writer.key("hostname");
        writer.value(hostName);

        writer.key("dump-port");
        writer.value(dumpPort);

        writer.key("base-port");
        writer.value(basePort);

        writer.key("search-port");
        writer.value(searchPort);

        writer.key("index-port");
        writer.value(indexerPort);

        writer.key("kamaji-port");
        writer.value(kamajiPort);

        writer.key("ljinx-port");
        writer.value(ljinxPort);

        writer.key("peach-port");
        writer.value(peachPort);
    }
}
