package ru.yandex.mail.search.web.searchmap;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

import ru.yandex.io.StringBuilderWriter;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonValue;
import ru.yandex.json.writer.JsonWriter;
import ru.yandex.json.writer.JsonWriterBase;
import ru.yandex.parser.searchmap.SearchMapShard;
import ru.yandex.parser.searchmap.ZooKeeperAddress;

public class SearchmapShardGroup implements JsonValue {
    private final Set<MailSearchHost> hosts;
    private final List<ZooKeeperAddress> zk;

    private final int iNum;

    private Set<Integer> shards = new LinkedHashSet<>();

    public SearchmapShardGroup(
        final SearchMapShard shard,
        final int num)
    {
        this.shards.add(num);
        this.zk = shard.zk();
        this.iNum = shard.iNum();
        this.hosts =
            shard
                .stream()
                .map(MailSearchHost::new)
                .collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public List<ZooKeeperAddress> zk() {
        return zk;
    }

    public int iNum() {
        return iNum;
    }

    public Set<MailSearchHost> hosts() {
        return hosts;
    }

    public void updateShardRange(final int num) {
        shards.add(num);
    }

    public Collection<Integer> shards() {
        return shards;
    }

    @Override
    public void writeValue(final JsonWriterBase writer) throws IOException {
        writer.key("iNum");
        writer.value(iNum);

        writer.key("shards");
        writer.value(shards);

        writer.key("zk");
        writer.value(zk);

        writer.key("hosts");
        writer.startArray();
        for (MailSearchHost host: hosts) {
            writer.startObject();
            writer.value(host);
            writer.endObject();
        }
        writer.endArray();
    }

    @Override
    public String toString() {
        StringBuilderWriter sbw = new StringBuilderWriter();
        try (JsonWriter jw = JsonType.NORMAL.create(sbw)) {
            jw.startObject();
            jw.value(this);
            jw.endObject();
        } catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return sbw.toString();
    }
}
