package ru.yandex.mail.search.web.searchmap;

import java.util.List;

import ru.yandex.parser.searchmap.SearchMapShard;
import ru.yandex.parser.searchmap.ZooKeeperAddress;

public class ShardGroupKey {
    private final int iNum;
    private final List<ZooKeeperAddress> zk;

    public ShardGroupKey(final SearchMapShard shard) {
        this.iNum = shard.iNum();
        this.zk = shard.zk();
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ShardGroupKey)) {
            return false;
        }

        ShardGroupKey that = (ShardGroupKey) o;

        if (iNum != that.iNum) {
            return false;
        }
        return zk.equals(that.zk);
    }

    // CSOFF: MagicNumber
    @Override
    public int hashCode() {
        int result = iNum;
        result = 31 * result + zk.hashCode();
        return result;
    }
    // CSON: MagicNumber
}
