package ru.yandex.ps.webtools.aceventura;

import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpHostConfigBuilder;
import ru.yandex.mail.search.web.config.AbstractPsProjectConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractAceventuraProjectConfigBuilder
    <T extends AbstractAceventuraProjectConfigBuilder<T>>
     extends AbstractPsProjectConfigBuilder<T>
     implements AceventuraProjectConfig
{
    private HttpHostConfigBuilder msalConfig;

    protected AbstractAceventuraProjectConfigBuilder(final AceventuraProjectConfig config) {
        super(config);
        msalConfig(config.msalConfig());
    }

    protected AbstractAceventuraProjectConfigBuilder(
        final IniConfig config,
        final AceventuraProjectConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
        this.msalConfig =
            new HttpHostConfigBuilder(
                config.section("msal"),
                defaults.msalConfig());
    }

    @Override()
    public HttpHostConfigBuilder msalConfig() {
        return msalConfig;
    }

    public T msalConfig(final HttpHostConfig value) {
        this.msalConfig = new HttpHostConfigBuilder(
            value);
        return self();
    }
}
